#version 130
#extension GL_EXT_gpu_shader4 : enable
// Wobbly Cube FieldMod01.fsh  by  kekwizard  
 
//https://www.shadertoy.com/view/3ttczX
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


float sdBox( vec3 p, vec3 b )
{
  vec3 d = abs(p) - b;
  return min(max(d.x,max(d.y,d.z)),0.0) + length(max(d,0.0));
}

float sdTorus( vec3 p, vec2 t )
{
  vec2 q = vec2(length(p.xz)-t.x,p.y);
  return length(q)-t.y;
}

 mat3 rotationMatrix(vec3 axis, float angle)
{
    axis = normalize(axis);
    float s = sin(angle);
    float c = cos(angle);
    float oc = 1.0 - c;
    
    return mat3(oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,
                oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,
                oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c);
}

float mixV(float a, float b, float d) {
	return (d * a)+(1.0 - d)*b;
}

float map(vec3 p)
{
    float m = 1.;
    vec3 boxsize = vec3(3.0, 3.0, 3.0);
    
    vec3 c = vec3(8., 15. + 3. * sin(iTime), 8.0);

        
    p.x = mod(p.x, c.x) - 0.5 * c.x; // p.z -0.05 - 0.05
    p.y = mod(p.y, c.y) - 0.5 * c.y; // p.z -0.05 - 0.05
    p.z = mod(p.z, c.z) - 0.5 * c.z; // p.z -0.05 - 0.05


    p.x += .75 * sin(p.z + 3. * iTime);
    p.y += .75 * cos(p.z + 6. * iTime);

    //float displacement = .5 * sin(iTime + 5.*p.x)*cos(iTime * 1.1 + 5.*p.y)*sin(iTime * 1.2 + 5.*p.z);    

    m = min(m, sdBox(p, boxsize));

    return m;
}

void getCamPos(inout vec3 ro, inout vec3 rd)
{
    ro.z = -15.0 + (iTime * 15.);
    ro.x = 4.0;
}

vec3 palette( in float t, in vec3 a, in vec3 b, in vec3 c, in vec3 d )
{
    return a + b*cos( 6.28318*(c*t+d) );
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{

   
    vec2 _p = (iResolution.xy - 2.0 * fragCoord.xy) / iResolution.y;
    vec3 ray = normalize(vec3(_p, 1.0));
    vec3 cam = vec3(0.0, 0.0, 0.0);
    bool hit = false;
    getCamPos(cam, ray);  
    
    //mat3 rm = rotationMatrix(vec3(0.66, 1., 0.9), iTime);

        
    float depth = 0.0, d = 0.0, iter = 0.0;
    vec3 p;
    
    for( int i = 0; i < 150; i ++)
    {
    	p = depth * ray + cam;
        d = map(p);
                  
        if (d < 0.001) {
			hit = true;
            break;
        }
                   
		depth += d;
		iter++;
                   
    }
    
    vec3 col = vec3(1.0 - iter / 150.0);
    /*
    const vec3 a = vec3(0.5, 0.5, 0.5);
    const vec3 b = vec3(0.5, 0.5, 0.5);
    const vec3 c = vec3(2., 1., 0.);
    const vec3 da = vec3(0.5, 0.2, 0.25);
*/
    
    const vec3 a = vec3(0.5, 0.5, 0.5);
    const vec3 b = vec3(0.5, 0.5, 0.5);
    const vec3 c = vec3(1., 1., 0.5);
    const vec3 da = vec3(0.8, 0.9, 0.3);
	
    
    
    vec3 sq = sqrt(col);
    
    vec3 gg = palette(sq.x * sq.y * sq.z, a, b, c, da);

    fragColor = vec4(gg, 0.0);
    
 return fragColor;    
}
///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc); // * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = 1.0;
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.